/*
 * Copyright (c) 2004 MUSIC TECHNOLOGY GROUP (MTG)
 *                         UNIVERSITAT POMPEU FABRA
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MpegAudioStream__
#define __MpegAudioStream__


#include <CLAM/AudioCodecs_Stream.hxx>
#include <CLAM/MpegBitstream.hxx>
#include <deque>
#include <CLAM/Array.hxx>

namespace CLAM
{

namespace AudioCodecs
{
	class MpegAudioStream 
		: public Stream
	{
	public:

		MpegAudioStream();
		MpegAudioStream( const AudioFile& file );
		
		~MpegAudioStream();

		void SetFOI( const AudioFile& file );

		void PrepareReading();
		void PrepareWriting();
		void PrepareReadWrite();
		void Dispose();

	protected:

		void AudioFileToNative( const AudioFile& file );
		void DiskToMemoryTransfer();
		void MemoryToDiskTransfer();

		void ConsumeDecodedSamples();

	protected:
		
		std::string   mName;
		FILE*         mpHandle;
		MpegBitstream mBitstream;
		int           mEncodedSampleRate;
		int           mEncodedChannels;

		static const TSize                    mMaxDecodedBlockSize;
		std::vector<std::deque<mad_fixed_t> > mDecodeBuffer;
		TSize                                 mSamplesDecoded;
		TSize                                 mSamplesTransferred;
	};
}

}


#endif // MpegAudioStream.hxx

