/*
 * Copyright (c) 2001-2004 MUSIC TECHNOLOGY GROUP (MTG)
 *                         UNIVERSITAT POMPEU FABRA
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


#ifndef _SMSDeesser_
#define _SMSDeesser_

#include <CLAM/InPort.hxx>
#include <CLAM/OutPort.hxx>
#include <CLAM/InControl.hxx>
#include <CLAM/Frame.hxx>
#include <CLAM/Spectrum.hxx>
#include <CLAM/SegmentTransformationConfig.hxx>
#include <CLAM/FrameTransformation.hxx>
#include <CLAM/FrameTransformationConfig.hxx>

#include <CLAM/Deesser.hxx>

namespace CLAM{


	class SMSDeesser: public FrameTransformation
	{
		
		const char *GetClassName() const {return "SMSDeesser";}

		InPort<Spectrum> mIn;
		OutPort<Spectrum> mOut;
		
		InControl mLowCutoffFreqCtl;
		InControl mHighCutoffFreqCtl;
		InControl mThresholdCtl;
	public:

		SMSDeesser() 
			: 
			mIn("In Spectrum", this), 
			mOut("Out Spectrum", this),
			mLowCutoffFreqCtl("LowCutoff", this),
			mHighCutoffFreqCtl("HighCutoff", this),
			mThresholdCtl("Threshold", this)
		{
			Configure( SegmentTransformationConfig() );
		}

 		~SMSDeesser() {}

		bool Do(const Frame& in, Frame& out)
		{
			return Do(in.GetResidualSpec(), out.GetResidualSpec());
		}

		bool Do(const Spectrum& in, Spectrum& out);

		bool Do()
		{
			bool result = Do(mIn.GetData(), mOut.GetData());
			mIn.Consume();
			mOut.Produce();
			return result;
		}
	private:
		Deesser mDeesser;
	
	};		
} //namespace CLAM

#endif // _SMSDeesser_

